DECLARE  iAantalDagen INTEGER;
SET iAantalDagen = (SELECT
                    Value as Betalingstermijn
                    FROM ENKData.settings
                    WHERE Name = 'Betalingstermijn');

SELECT TOP 10

  f.Faktuurnr as Factuurnr,
  f.faktuurdatum as factuurdatum,
  cast(Current_date as integer)-Cast(f.faktuurdatum as integer) as AantalDagenOpen,
  INCDAY(f.Faktuurdatum,COALESCE(b.Aantaldagen2,iAantalDagen)) as UitersteBetaaldatum,
  r.Naam,
  f.Faktuurbedrag as Factuurbedrag

FROM relaties r
INNER JOIN facturen f ON (f.relatienr=r.relatienr)
LEFT JOIN betalingscondities b ON (b.betalingsconditie=f.betalingsconditie)
WHERE f.Recordstatus Between 19 and 30
ORDER by UitersteBetaaldatum
